import usb.core
import usb.util
import sys
import os

# Scanning the tree for our DualShock 3 controller
controller = usb.core.find(idVendor=0x054c, idProduct=0x0268)

# In case the resource is busy
reattach = False
if controller.is_kernel_driver_active(0):
    reattach = True
    controller.detach_kernel_driver(0)

# Error message for device if not found
if cotroller is None:
    raise ValueError('Device not found')

# Set the active configuration. With no arguments, the first configuration will be the active one
controller.set_configuration()

# Initialising values
xaxis = 0
yaxis = 0
temp_xaxis = 0
temp_yaxis = 0
prev_stop = 0
lock = 0
stop = 0

while True:

  # Our “SetupPacket”
  ret = dev.ctrl_transfer(0xa1, 0x1, 0x0101, 0x0, 0x31)

  # Check for anti-clockwise rotation on the x-axis
  if ret[41] == 2:
    if ret[42] <= 110 and ret[42] >= 0:
      xaxis = ret[42]*90/110

      # Limit maximum to 90 degrees
      if xaxis > 90:
      xaxis = 90

  # Check for clockwise rotation on the x-axis
  if ret[41] == 1:
    if ret[42] <= 255 and ret[42] >= 142:
      xaxis = (ret[42] - 255)*90/113 

      # Limit maximum to 90 degrees
      if xaxis < -90:
        xaxis = -90 

  # Check for anti-clockwise rotation on the y-axis
  if ret[43] == 2:
    if ret[44] <= 110 and ret[44] >= 0:
      yaxis = ret[44]*90/110

      # Limit maximum to 90 degrees
      if yaxis > 90:
        yaxis = 90  

  # Check for clockwise rotation on the y-axis
  if ret[43] == 1:
    if ret[42] <= 255 and ret[42] >= 142:
      yaxis = (ret[44] - 255)*90/115

      # Limit maximum to 90 degrees
      if yaxis < -90:
        yaxis = -90  

  # Check if 'X' has been pressed, set the stop flag if so
  if ret[3] == 64:
    stop = 1

  # Clear the stop flag if 'X' has been released
  if ret[3] == 0:
    stop = 0    
     
  # This logic sends the pervious rotation values again, so that the framebuffer can clear the previous render before 
  # printing the new one   
  if stop == 0:
    lock = 0
    if prev_stop == 1:
      os.system("./hello " + str(temp_yaxis) + " " + str(temp_xaxis) + " " + str(stop) + " " + str(prev_stop))
      else:
        os.system("./hello " + str(yaxis) + " " + str(xaxis) + " " + str(stop) + " " + str(prev_stop))

      # Storing the previous rotation values  
      temp_yaxis = yaxis
      temp_xaxis = xaxis
      prev_stop = 0

    # If the 'X' button has been pressed, send the previous rotation values and stop sending any new values to prevent
    # the current from being overwritten in the framebuffer
    if stop == 1:
      if lock == 0:
        os.system("./hello " + str(temp_yaxis) + " " + str(temp_xaxis) + " " + str(stop) + " " + str(prev_stop))      
        lock = 1
        prev_stop = 1  